// Here's some stuff I'm testing with
// Try these lines in the Default Map flags file:
// on_key=respond_to_key@ { key: z_key, mod: control_mod }
// on_key=set_point@ { key: x_key, mod: control_mod, pointname: "health", value: "5r15" }
// on_key=test_comparison@ { key: c_key, mod: control_mod }
// Try this line in a skill file:
// after_perform=announce_stuff@ { message: "this happens after the perform logic" }
// after_perform=summon_test@ { unit_type: "archer" }
// Try these lines in an effect file:
// after_applied=announce_applied@ { }
// after_removed=announce_removed@ { }
// after_fizzled=announce_fizzled@ { }
// Try this line in a unit file:
// after_death=announce_death@ { }
// after_create=create_unit_test@ { }

// Let's setup our global object
global.ian_reed = {};

function announce_stuff(l) {
	say(l.message);
	if (l.target_unit) {
		say(l.source_unit.Name + " finished using " + l.skill.Name + " on " + l.target_unit.Name);
	} else {
		say(l.source_unit.Name + " finished using " + l.skill.Name + " at " + shared.GetPos(l.target_tile));
	}
}

function respond_to_key(l) {
	// key and mod are what the user passed in, k and m are what the engine passes when a key was pressed
	if (l.k != l.key || l.m != l.mod) {
		return; // it's not the key combination we are supposed to respond to.
	}
	var allTiles = shared.Map.AllTiles;
	say("there are " + allTiles.length + " tiles in this map");
//	for (var i = 0; i < allTiles.length; ++i) {
//		say("tile " + shared.GetPos(allTiles[i]));
//	}

	// We can loop over the l object to see what's available because it's actually a javascript object
	for (var key in l) {
		say("l." + key + " = " + l[key]);
	}

	// note that the shared object is special because it's actually a C# object and so we can't for loop over it to tell which properties are on it.  I'm afraid we'll have this problem with all C# objects
//	for (var key in shared) {
//		say("shared." + key + " = " + shared[key]);
//	}

	// here we could get the current tile and selected unit and announce a bit of information off of them
	var tile = shared.Map.ReviewTile;
	var unit = tile.Selected;
	if (unit) {
		say("The selected unit is " + unit.Name + " the " + unit.Type);
	} else {
		say("No unit selected");
	}
	var units = tile.Units;
	var structures = tile.Structures;
	var effects = tile.Effects;
	say("This tile has " + units.length + " units");
	say("This tile has " + structures.length + " structures");
	say("This tile has " + effects.length + " effects");
}

function set_point(l) {
	// key and mod are what the user passed in, k and m are what the engine passes when a key was pressed
	if (l.k != l.key || l.m != l.mod) {
		return; // it's not the key combination we are supposed to respond to.
	}
	var pn = shared.PrepareForIndexing(l.pointname);
	var v = shared.Calculate(l.value);
	var unit = shared.Map.ReviewTile.Selected;
	if (!unit) {
		say("No unit is selected");
		return;
	}
	var old = unit.Points.get(pn).Current;
	unit.Points.get(pn).Current = v;
	say("The unit had " + old + " " + pn + " but now has " + v);
}

function announce_applied(args) {
	var effectName = args.effect.Name;
	var unitName = args.target_unit.GetName();
	say("The script knows that " + effectName + " was applied to " + unitName);
}
function announce_removed(args) {
	var effectName = args.effect.Name;
	var unitName = args.target_unit.GetName();
	say("The script knows that " + effectName + " was removed from " + unitName);
}
function announce_fizzled(args) {
	var effectName = args.effect.Name;
	var unitName = args.target_unit.GetName();
	say("The script knows that " + effectName + " fizzled from " + unitName);
}
function announce_death(args) {
	var unitName = args.unit.GetName();
	say("The script knows that " + unitName + " died");
}

function test_comparison(args) {
	// key and mod are what the user passed in, k and m are what the engine passes when a key was pressed
	if (args.k != args.key || args.m != args.mod) {
		return; // it's not the key combination we are supposed to respond to.
	}
	var g = shared.GetStorage("ian_reed");
	// just testing how well comparison works
	var unit = shared.Map.ReviewTile.Selected;
	if (!unit) {
		say("no unit selected");
		return; // no unit so nothing to do
	}
	// sadly the reference comparison never works.  Probably related to the fact that the unit is really a C# object being exposed to javascript and the javascript hosting library probably creates a new wrapper object each time it gives you a reference to a C# object.
	if (unit == g.get("last_unit"))
		say("reference comparison says this unit is the same as the last one");
	// well we can still get the job done with unique IDs on each unit.
	//say("the unit's ID is " + unit.ID);
	//shared.AnnounceType(g["last_unit_id"]);
	//shared.AnnounceType(g[0]);
	//say(g.length);
	var keys = g.keys;
	for (var i=0; i < keys.length; i++) {
		var key = keys[i];
		var value = g.get(key);
		say(key + " = " + value);
	}
	if (unit.ID == g.get("last_unit_id"))
		say("ID comparison says this unit is the same as the last one");
	g.set("last_unit", unit);
	g.set("last_unit_id", unit.ID);
	//g["last_unit"] = unit;
	//g["last_unit_id"] = unit.ID;
}
function summon_test(args) {
	var unit = shared.CreateUnit(args.unit_type);
	var tile = shared.Map.ReviewTile;
	shared.Map.AddUnit(unit, tile.X, tile.Y);
	say("Summoned " + args.unit_type);
}
function create_unit_test(args) {
if (!args)
say("args was undefined");
if (!args.unit)
say("unit was undefined");
	var name = args.unit.GetName();
	say(name + " was created");
}
function announce_message(args) {
	if (args.unit) {
		if (args.unit.ScriptFlags.get("announce_name")) {
			say(args.unit.FriendlyName);
		}
	}
	say(args.message);
}
